from substrate import LLMClient

llm_client = LLMClient(use_dev_capacity=True)
MAX_TOKENS = 2000

def llm_generation(prompt)-> str|None:
    request_data = {
        "prompt": prompt,
        "max_tokens": MAX_TOKENS,
        "temperature": 0.1,
        "top_p": 1,
        "n": 1,
        "stream": False,
        "logprobs": None,
        "stop": "",
    }
    try:
        response = llm_client.send_request("dev-moonshot", request_data)
        generation = response["choices"][0]["text"]
        prompt_token_length = response['usage']['prompt_tokens']
    except Exception as e:
        print(e)
        generation = None 
        prompt_token_length = None
    return {'text': generation, 'token_length': prompt_token_length}
